<?php
session_start();
if (empty($_SESSION['user_id']) || $_SESSION['role'] !== 'member') {
    header('Location: login.php');
    exit;
}

$products = json_decode(file_get_contents('products.json'), true);
$orders = file_exists('orders.json') ? json_decode(file_get_contents('orders.json'), true) : [];

$productId = intval($_GET['id'] ?? 0);
$product = array_filter($products, fn($x) => $x['id'] === $productId);
if (!$product) die('Produk tidak ditemukan.');
$product = array_shift($product);

// Cek apakah user ini punya akses produk ini
$userId = $_SESSION['user_id'];
$validOrder = false;
foreach ($orders as $o) {
    if ($o['user_id'] === $userId && $o['product_id'] === $productId && $o['status'] === 'sent') {
        $validOrder = true;
        break;
    }
}
if (!$validOrder) {
    die('Anda tidak memiliki akses ke produk ini.');
}
?>
<!DOCTYPE html>
<html>
<head><meta charset="utf-8"><title><?= htmlentities($product['name']) ?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"></head>
<body class="p-4">
    <div class="card mx-auto" style="max-width: 600px;">
        <div class="card-header"><?= htmlentities($product['name']) ?></div>
        <div class="card-body">
            <p>Harga: <strong><?= htmlentities($product['price']) ?></strong></p>
            <p><?= nl2br(htmlentities($product['desc'])) ?></p>

            <?php if (!empty($product['link'])): ?>
                <div class="mb-3">
                    <a href="<?= htmlentities($product['link']) ?>" class="btn btn-success" target="_blank">Download Produk</a>
                </div>
            <?php endif; ?>

            <?php if (!empty($product['video'])):
                parse_str(parse_url($product['video'], PHP_URL_QUERY), $yt);
                $vid = $yt['v'] ?? '';
                if ($vid): ?>
                    <div class="ratio ratio-16x9 mb-3">
                        <iframe src="https://www.youtube.com/embed/<?= htmlentities($vid) ?>" allowfullscreen></iframe>
                    </div>
                <?php endif;
            endif; ?>

            <?php if (!empty($product['content'])): ?>
                <div class="mt-3"><?= nl2br(htmlentities($product['content'])) ?></div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
