<?php
session_start();
if (empty($_SESSION['user_id']) || $_SESSION['role'] !== 'member') {
    header('Location: login.php');
    exit;
}

$userId = $_SESSION['user_id'];

$products = file_exists('products.json') ? json_decode(file_get_contents('products.json'), true) : [];
$orders = file_exists('orders.json') ? json_decode(file_get_contents('orders.json'), true) : [];

// Ambil produk yang sudah dibeli atau masih pending
$myOrders = array_filter($orders, fn($o) => isset($o['user_id'], $o['product_id']) && $o['user_id'] === $userId);
$myProductIds = array_column($myOrders, 'product_id');

// Filter produk yang belum dibeli
$availableProducts = array_filter($products, fn($p) => !in_array($p['id'], $myProductIds));
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<title>Produk Tersedia</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4">
<div class="container">
  <h3>Produk Tersedia untuk Dibeli</h3>

  <?php if (empty($availableProducts)): ?>
    <div class="alert alert-success">Semua produk sudah Anda beli.</div>
    <a href="produk.php" class="btn btn-secondary">Kembali ke Dashboard</a>
  <?php else: ?>
    <ul class="list-group mb-3">
      <?php foreach ($availableProducts as $prod): ?>
        <li class="list-group-item">
          <h5><?= htmlentities($prod['name']) ?></h5>
          <p><?= nl2br(htmlentities($prod['desc'])) ?></p>
          <p><strong>Harga:</strong> Rp<?= number_format($prod['price'], 0, ',', '.') ?></p>
          
          <?php if (!empty($prod['landingpage'])): ?>
            <a href="<?= htmlentities($prod['landingpage']) ?>" target="_blank" class="btn btn-info mb-2">Lihat Detail</a>
          <?php endif; ?>
          
          <a href="checkout.php?id=<?= $prod['id'] ?>" class="btn btn-primary ms-2">Beli Produk Ini</a>
        </li>
      <?php endforeach; ?>
    </ul>
    <a href="produk.php" class="btn btn-secondary">Kembali ke Dashboard</a>
  <?php endif; ?>
</div>
</body>
</html>
