<?php
session_start();
if (!empty($_SESSION['user_id'])) {
    header('Location: ' . ($_SESSION['role'] === 'admin' ? 'admin.php' : 'produk.php'));
    exit;
}

$users = file_exists('users.json') ? json_decode(file_get_contents('users.json'), true) : [];
$loginError = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $u = trim($_POST['username']);
    $p = trim($_POST['password']);
    foreach ($users as $user) {
        if ($user['username'] === $u && password_verify($p, $user['password'])) {
            // Cek expired untuk member
            if ($user['role'] === 'member' && !empty($user['expire_date']) && strtotime($user['expire_date']) < time()) {
                $loginError = 'Akun Anda sudah kadaluwarsa.';
                break;
            }

            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $u;
            $_SESSION['role'] = $user['role'];
            header('Location: ' . ($user['role'] === 'admin' ? 'admin.php' : 'produk.php'));
            exit;
        }
    }
    if (empty($loginError)) {
        $loginError = 'Username atau password salah.';
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Login</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="d-flex justify-content-center align-items-center vh-100">
<div class="card p-4" style="width: 400px;">
    <h4 class="mb-3 text-center">Login</h4>

    <?php if (!empty($loginError)): ?>
        <div class="alert alert-danger"><?= $loginError ?></div>
    <?php endif; ?>

    <?php if (!empty($_GET['reset']) && $_GET['reset'] === 'success'): ?>
        <div class="alert alert-success">Password berhasil diubah. Silakan login.</div>
    <?php endif; ?>

    <form method="POST">
        <input name="username" class="form-control mb-2" placeholder="Username / Email" required>
        <input name="password" type="password" class="form-control mb-3" placeholder="Password" required>
        <button class="btn btn-primary w-100 mb-2">Login</button>
    </form>

    <a href="reset_request_member.php" class="btn btn-link w-100 text-center">Lupa Password Member?</a>
</div>
</body>
</html>
