<?php
session_start();
if (empty($_SESSION['user_id'])) header('Location: login.php');
$orders = file_exists('orders.json') ? json_decode(file_get_contents('orders.json'), true) : [];
$myOrders = array_filter($orders, fn($o) => $o['user_id'] === $_SESSION['user_id']);
?>
<!DOCTYPE html><html><head><meta charset="utf-8"><title>Riwayat Pembelian</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"></head><body class="p-4">
  <h2>Riwayat Pembelian <?= htmlentities($_SESSION['username']) ?></h2>
  <table class="table table-bordered mt-3">
    <thead><tr><th>#</th><th>Produk</th><th>Tgl Pesan</th><th>Status</th></tr></thead>
    <tbody>
      <?php foreach ($myOrders as $i => $o): ?>
        <tr>
          <td><?= $i+1 ?></td>
          <td><?= htmlentities($o['product_name']) ?></td>
          <td><?= htmlentities($o['date'] ?? '-') ?></td>
          <td><?= ucfirst($o['status']) ?></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
  <a href="produk.php" class="btn btn-secondary">Kembali ke Produk</a>
</body></html>
