<?php
session_start();

if (empty($_SESSION['user_id']) || $_SESSION['role'] !== 'member') {
    header('Location: login.php');
    exit;
}

$products = file_exists('products.json') ? json_decode(file_get_contents('products.json'), true) : [];
$orders = file_exists('orders.json') ? json_decode(file_get_contents('orders.json'), true) : [];

$productId = intval($_GET['id'] ?? 0);
$product = array_filter($products, fn($p) => $p['id'] === $productId);
$product = $product ? array_shift($product) : null;

if (!$product) {
    echo "<div class='p-4 text-center'><h3>Produk tidak ditemukan.</h3><a href='produk.php' class='btn btn-secondary mt-3'>Kembali ke Dashboard</a></div>";
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $orders[] = [
        'name' => $_SESSION['username'],
        'wa' => $_POST['wa'],
        'product_id' => $productId,
        'product_name' => $product['name'],
        'status' => 'pending',
        'user_id' => $_SESSION['user_id']
    ];
    file_put_contents('orders.json', json_encode($orders, JSON_PRETTY_PRINT));

    $orderId = count($orders) - 1;
    header("Location: payment.php?order_id=$orderId");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Checkout Produk</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4">
<div class="container">
    <h3>Checkout Produk: <?= htmlentities($product['name']) ?></h3>
    <p>Harga: <strong><?= htmlentities($product['price']) ?></strong></p>
    <p><?= nl2br(htmlentities($product['desc'])) ?></p>

    <form method="POST">
        <div class="mb-3">
            <label>Nomor WhatsApp Anda:</label>
            <input name="wa" class="form-control" placeholder="Contoh: 6281234567890" required>
        </div>
        <button class="btn btn-primary">Lanjut ke Pembayaran</button>
    </form>
</div>
</body>
</html>
